<?php 
Yii::app()->clientScript->registerScript('game', <<<SCRIPT

		

		$("#addNewAnswer").click(function(){
			var maxAnswerId = -1;
			$('#answersContainer').find('div').each(function(){
				if($(this).attr('answerId')!=undefined && parseInt($(this).attr('answerId')) > maxAnswerId)
					maxAnswerId = $(this).attr('answerId');
			});
			var newAnswerId = parseInt(maxAnswerId)+1;

			var answersCount = 1;
			$("#answersContainer").find('label').each(function(){
				answersCount++;
			});

			var answerInput = '<div class="row" answerId="'+newAnswerId+'">\
									<label for="SzkolenieOdpowiedziEgzamin_'+newAnswerId+'_tresc">tresc '+answersCount+'</label>\
									<textarea size="60" maxlength="4000" cols="60" rows="8" name="SzkolenieOdpowiedziEgzamin['+newAnswerId+'][tresc]" id="SzkolenieOdpowiedziEgzamin_'+newAnswerId+'_tresc"></textarea>\
									<br /><a href="#" class="removeAnswer">Usuń tą odpowiedź</a>\
								</div>';
			$("#answersContainer").append(answerInput);
			return false;
		});

		$('.form').on('click', '.removeAnswer',function(){
				$(this).parent().remove();
				var i = 1;
				$("#answersContainer").find('label').each(function(){
					$(this).text('Odpowiedź '+i);
					i++;
				});
				return false;
		});


SCRIPT
, CClientScript::POS_READY);
?>

<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'szkolenie-form',
	'enableAjaxValidation'=>false,
	'htmlOptions'=>array('enctype'=>'multipart/form-data')
)); ?>

	<div class="row">
		<?php echo $form->labelEx($model,'tresc'); ?>
		<?php echo $form->textArea($model,'tresc',array('size'=>60,'maxlength'=>4000,'cols'=>60,'rows'=>8)); ?>
		<?php echo $form->error($model,'tresc'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'image'); ?>
		<?php if($this->action->id=='addQuestion' && !empty($model->tempImageName)): ?>
			<img id="uploadedImage" src="<?php echo Yii::app()->baseUrl ?>/uploads/temp/<?php echo $model->tempFolderName ?>/<?php echo $model->tempImageName ?>" />
		<?php elseif($this->action->id=='updateQuestion' && !empty($model->urlObrazka)): ?>
			<img id="uploadedImage" src="<?php echo Yii::app()->baseUrl ?>/<?php echo $model->urlObrazka ?>" />
		<?php endif; ?>
		<?php echo $form->fileField($model, 'image', array('onchange'=>'$("#uploadedImage").remove();')); ?>
		<?php echo $form->error($model,'image'); ?>
	</div>

	<?php echo CHtml::activeHiddenField($model, 'tempFolderName') ?>
	<?php echo CHtml::activeHiddenField($model, 'tempImageName') ?>

	<div class="row">
		<label>Odpowiedzi</label>
		<div id="answersContainer">
			<?php foreach($answers as $i=>$answer): ?>
				<div answerId="<?php echo $i ?>">
					<label for="SzkolenieOdpowiedziEgzamin_<?php echo $i ?>_odpowiedz">odpowiedz <?php echo $i+1 ?></label>
					<?php echo $form->textArea($answer,'['.$i.']tresc',array('size'=>60,'maxlength'=>4000,'cols'=>60,'rows'=>8)); ?>
					<?php echo $form->error($answer,'['.$i.']tresc'); ?>
					<br /><a href="#" class="removeAnswer">Usuń tą odpowiedź</a>
				</div>
			<?php endforeach; ?>
		</div>
		<button id="addNewAnswer">Dodaj nową odpowiedź</button>
	</div>

	<div class="row buttons">
		<?php echo CHtml::submitButton('Dodaj',array('class'=>'buttonS bLightBlue')); ?>
	</div>

<?php $this->endWidget(); ?>

</div>